/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.wishingforsunshine.repack.registrate.builders;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import noobanidus.mods.wishingforsunshine.repack.registrate.AbstractRegistrate;
import noobanidus.mods.wishingforsunshine.repack.registrate.builders.AbstractBuilder;
import noobanidus.mods.wishingforsunshine.repack.registrate.builders.BuilderCallback;
import noobanidus.mods.wishingforsunshine.repack.registrate.builders.ItemBuilder;
import noobanidus.mods.wishingforsunshine.repack.registrate.providers.ProviderType;
import noobanidus.mods.wishingforsunshine.repack.registrate.providers.loot.RegistrateEntityLootTables;
import noobanidus.mods.wishingforsunshine.repack.registrate.providers.loot.RegistrateLootTableProvider;
import noobanidus.mods.wishingforsunshine.repack.registrate.util.LazySpawnEggItem;
import noobanidus.mods.wishingforsunshine.repack.registrate.util.OneTimeEventReceiver;
import noobanidus.mods.wishingforsunshine.repack.registrate.util.entry.EntityEntry;
import noobanidus.mods.wishingforsunshine.repack.registrate.util.entry.RegistryEntry;
import noobanidus.mods.wishingforsunshine.repack.registrate.util.nullness.NonNullBiConsumer;
import noobanidus.mods.wishingforsunshine.repack.registrate.util.nullness.NonNullConsumer;
import noobanidus.mods.wishingforsunshine.repack.registrate.util.nullness.NonNullSupplier;

public class EntityBuilder<T extends Entity, P>
extends AbstractBuilder<EntityType<?>, EntityType<T>, P, EntityBuilder<T, P>> {
    private final NonNullSupplier<EntityType.Builder<T>> builder;
    private NonNullConsumer<EntityType.Builder<T>> builderCallback = $ -> {};
    @Nullable
    private NonNullSupplier<IRenderFactory<? super T>> renderer;
    private boolean spawnConfigured;
    @Nullable
    private ItemBuilder<LazySpawnEggItem<T>, EntityBuilder<T, P>> spawnEggBuilder;

    public static <T extends Entity, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.IFactory<T> factory, EntityClassification classification) {
        return new EntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    protected EntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.IFactory<T> factory, EntityClassification classification) {
        super(owner, parent, name, callback, EntityType.class);
        this.builder = () -> EntityType.Builder.func_220322_a((EntityType.IFactory)factory, (EntityClassification)classification);
    }

    public EntityBuilder<T, P> properties(NonNullConsumer<EntityType.Builder<T>> cons) {
        this.builderCallback = this.builderCallback.andThen(cons);
        return this;
    }

    public EntityBuilder<T, P> renderer(NonNullSupplier<IRenderFactory<? super T>> renderer) {
        if (this.renderer == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this;
    }

    protected void registerRenderer() {
        OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<IRenderFactory<T>> renderer = this.renderer;
            if (renderer != null) {
                try {
                    RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)this.getEntry()), renderer.get());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to register renderer for Entity " + ((RegistryEntry)this.get()).getId(), e);
                }
            }
        });
    }

    public EntityBuilder<T, P> spawnPlacement(EntitySpawnPlacementRegistry.PlacementType type, Heightmap.Type heightmap, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        if (this.spawnConfigured) {
            throw new IllegalStateException("Cannot configure spawn placement more than once");
        }
        this.spawnConfigured = true;
        this.onRegister(t -> EntitySpawnPlacementRegistry.func_209343_a((EntityType)t, (EntitySpawnPlacementRegistry.PlacementType)type, (Heightmap.Type)heightmap, (EntitySpawnPlacementRegistry.IPlacementPredicate)predicate));
        return this;
    }

    @Deprecated
    public EntityBuilder<T, P> defaultSpawnEgg(int primaryColor, int secondaryColor) {
        return (EntityBuilder)this.spawnEgg(primaryColor, secondaryColor).build();
    }

    @Deprecated
    public ItemBuilder<? extends SpawnEggItem, EntityBuilder<T, P>> spawnEgg(int primaryColor, int secondaryColor) {
        ItemBuilder<LazySpawnEggItem, EntityBuilder<T, P>> ret = this.getOwner().item(this, this.getName() + "_spawn_egg", p -> new LazySpawnEggItem(this.asSupplier(), primaryColor, secondaryColor, (Item.Properties)p)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        });
        if (this.spawnEggBuilder == null) {
            this.onRegister(this::injectSpawnEggType);
        }
        this.spawnEggBuilder = ret;
        return ret;
    }

    public EntityBuilder<T, P> defaultLang() {
        return (EntityBuilder)this.lang(EntityType::func_210760_d);
    }

    public EntityBuilder<T, P> lang(String name) {
        return (EntityBuilder)this.lang(EntityType::func_210760_d, name);
    }

    public EntityBuilder<T, P> loot(NonNullBiConsumer<RegistrateEntityLootTables, EntityType<T>> cons) {
        return (EntityBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.ENTITY, tb -> cons.accept((RegistrateEntityLootTables)tb, (EntityType)ctx.getEntry())));
    }

    @SafeVarargs
    public final EntityBuilder<T, P> tag(ITag.INamedTag<EntityType<?>> ... tags) {
        return (EntityBuilder)this.tag(ProviderType.ENTITY_TAGS, tags);
    }

    @Override
    protected EntityType<T> createEntry() {
        EntityType.Builder<T> builder = this.builder.get();
        this.builderCallback.accept(builder);
        return builder.func_206830_a(this.getName());
    }

    protected void injectSpawnEggType(EntityType<T> entry) {
        ItemBuilder<LazySpawnEggItem<T>, EntityBuilder<T, P>> spawnEggBuilder = this.spawnEggBuilder;
        if (spawnEggBuilder != null) {
            ((LazySpawnEggItem)((Object)spawnEggBuilder.getEntry())).injectType();
        }
    }

    @Override
    protected RegistryEntry<EntityType<T>> createEntryWrapper(RegistryObject<EntityType<T>> delegate) {
        return new EntityEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public EntityEntry<T> register() {
        return (EntityEntry)super.register();
    }
}

